@echo off
rem  Library deployment script - v4 b20250625-Current: Updated FTView SE folder creation, Copying Library files, Help File folder (Final zip file name should be in format:Hardy_Device_Library_v1.01.00)
rem	 Library deployment script - v3 b20230216: Copy ACM libraries/templates to default location(s)|Register ACM libraries via ACM CLI|Copy FTOptix libraries to default user location(s)|Option to lauch quickstart.
rem	 Library deployment script - v2 b20210115: Copy ACM libraries/templates to default location(s)|Register ACM libraries via ACM CLI|Option to lauch quickstart.
rem  Run this file to deploy the libraries and templates contained in this download
echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
echo :: Library Deployment
echo ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

SETLOCAL ENABLEDELAYEDEXPANSION
SETLOCAL ENABLEEXTENSIONS

rem Set library name. This will be used as the base name of the file folder the libraries will be copied to.  This name will be appended with _[BuildID] which represents the build or version number used on the parent folder of the distribution package.
SET _Library=(RA-LIB) HardyDevice

rem  Identify Parent / Child
SET _parent=%~dp0
SET _me=%~n0

rem  Get parent folder name 
for %%I in ("%~dp0") do for %%J in ("%%~dpI.") do set _ParentFolderName=%%~nxJ
rem echo %_ParentFolderName%
	
rem  Isolate release build id
for /f "tokens=1* delims=_" %%a in ("%_ParentFolderName%") do set _ReleaseBuild=%%b

rem  Determing if release build exists
if [%_ReleaseBuild%]==[] ( set _ReleaseBuild=Undefined)

rem  Display P/L/B
echo Package:	%_ParentFolderName% 
echo Library:	%_Library%
echo Build:		%_ReleaseBuild%
echo.
:: Get version only
::set _Version = %_ParentFolderName:~-8%
for /f "tokens=1,2,3,4 delims=_" %%a in ("%_ParentFolderName%") do set _LibName=%%a&set _Dvc=%%b&set _Lib=%%c&set _Version=%%d

:: Output the extracted folder name
echo Version: %_Version%

rem  Verify valid build number
echo :: -------------------
echo :: Identifying Build Number
echo :: -------------------
echo.
rem  If build number undefined, notify
if %_ReleaseBuild%==Undefined (
echo    -- Build Number could NOT be identified.  Build Number will be set to ZERO.
set _ReleaseBuild=00000000
) else (
echo    -- Build Number Identified)
echo.

::--------------------------------------------------------------------------------------------------------------------------------------------------------

rem  Check if ACM is installed
echo :: ------------------- 
echo :: Verifying ACM Install Status
echo :: -------------------
echo. 
IF NOT EXIST "C:\Program Files\Rockwell Automation\Application Code Manager" (
	set _DepSts=Application Code Manager library deployment stopped. Application Code Manager cannot be located at the default installation path
	goto ACMDepEnd
)
echo    -- Software Installation Verified
echo.

rem  GetPath
FOR /F "tokens=3*" %%A IN ('REG.EXE QUERY "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders" /V "Common Documents" 2^>NUL ^| FIND "REG_SZ"') DO SET CommonDocs=%%B\Studio 5000

rem Copy Libraries & Templates
echo :: -------------------
echo :: Copying Application Code Manager Libraries
echo :: -------------------
IF EXIST "%~dp0.\ApplicationCodeManagerLibraries" (
  robocopy "%~dp0.\ApplicationCodeManagerLibraries" "%CommonDocs%\Libraries\Application Code Manager\%_Library%_%_ReleaseBuild%" *.HSL4 *.HZ1 *.txt /e /copy:DAT /dcopy:DAT /NFL /NDL /NJH /NJS /nc /ns /np
  echo    -- Copy Complete
  echo.
) else (
  echo    -- Source File Folder Not Found:  .\ApplicationCodeManagerLibraries
  echo.
)

echo :: -------------------
echo :: Copying Application Code Manager Templates
echo :: -------------------
IF EXIST "%~dp0.\ApplicationCodeManagerTemplates" (
	robocopy "%~dp0.\ApplicationCodeManagerTemplates" "%CommonDocs%\Templates\Application Code Manager\(RA-TPL) ACM 2.00" *.xml /copy:DAT /NFL /NDL /NJH /NJS /nc /ns /np
	echo    -- Copy Complete
	echo.
) else (
	echo    -- Source File Folder Not Found:  .\ApplicationCodeManagerTemplates
	echo.
)

IF NOT Exist "%~dp0.\ApplicationCodeManagerLibraries" (
	set _DepSts=Application Code Manager library deployment stopped. No libraries to register.
	goto ACMDepEnd
)

rem Assemble ACM import script
echo :: -------------------
echo :: Generating Application Code Manager Library Registration Script
echo :: -------------------
echo.
echo    -- Be patient, the duration of this process varies based on library size
echo //ACM Library Registration Script > "%_parent%ACMCLI_RegisterLibraries.txt"
echo |set /p="RegisterLibrary " >> "%_parent%ACMCLI_RegisterLibraries.txt"
for /f "delims=" %%a in ('dir "%CommonDocs%\Libraries\Application Code Manager\%_Library%_%_ReleaseBuild%\"*.HSL4 /b/s/a:-d/o:e') do (
    echo|set /p=""%%a"," >> "%_parent%ACMCLI_RegisterLibraries.txt"   
)
echo    -- Script Complete
echo.

rem Run ACM Script
echo :: -------------------
echo :: Registering Application Code Manager Libraries
echo :: -------------------
echo.
echo    -- Be patient, the duration of this process varies based on library size
"C:\Program Files\Rockwell Automation\Application Code Manager\ACMConsole\ACMConsole.exe" -p "%_parent%ACMCLI_RegisterLibraries.txt" 
echo    -- Registration Complete
echo.
del "%_parent%ACMCLI_RegisterLibraries.txt"
set _DepSts=Application Code Manager library deployment: Complete
:ACMDepEnd
echo.
echo -------------------
echo %_DepSts%
echo -------------------
echo.

::--------------------------------------------------------------------------------------------------------------------------------------------------------

:FTOptixLibSetup
rem  Check if FactoryTalk Optix Studio is installed
echo :: ------------------- 
echo :: Verifying FactoryTalk Optix Studio Install Status
echo :: -------------------
echo. 
IF NOT EXIST "C:\Program Files\Rockwell Automation\FactoryTalk Optix" (
	set _DepSts=FactoryTalk Optix library deployment: Stopped - FactoryTalk Optix Studio cannot be located at the default installation path.
	goto OptixDepEnd
)
echo    -- Software Installation Verified
echo.

rem  GetPath
for /f "tokens=2*" %%h in ('%__APPDIR__%reg.exe query "HKCU\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders"^|find/i "Personal"')do <con: call set "UserDocs=%%~i\Rockwell Automation\FactoryTalk Optix"

rem Copy Libraries & Templates
echo :: -------------------
echo :: Copying FactoryTalk Optix Libraries
echo :: -------------------
IF EXIST "%~dp0.\FactoryTalkOptixLibraries" (
  robocopy "%~dp0.\FactoryTalkOptixLibraries" "%UserDocs%\Libraries" /e /copy:DAT /dcopy:DAT /NFL /NDL /NJH /NJS /nc /ns /np
  echo    -- Copy Complete
  echo.
  set _DepSts=FactoryTalk Optix library deployment: Complete
) else (
  echo    -- Source File Folder Not Found:  .\FactoryTalkOptixLibraries
  set _DepSts=FactoryTalk Optix library deployment stopped. No libraries to deploy.
  echo.
)
:OptixDepEnd
echo.
echo -------------------
echo %_DepSts%
echo -------------------
echo.

::--------------------------------------------------------------------------------------------------------------------------------------------------------

rem Check if FT View Software is installed
echo :: -------------------
echo :: Verifying FactoryTalk View Install Status
echo :: -------------------
echo.
IF NOT EXIST "C:\Users\Public\Documents\RSView Enterprise" (
set _DepSts=FactoryTalk View library deployment: Stopped - FactoryTalk View cannot be located at the default installation path.
goto FTViewDepEnd
)
echo    -- Software Installation Verified
echo.

::--------------------------------------------------------------------------------------------------------------------------------------------------------
rem Copy Help Files
echo :: -------------------
echo :: Copying FactoryTalk View Help Files
echo :: -------------------
IF NOT EXIST "C:\Users\Public\Documents\RSView Enterprise\Help_Files_Folder" (
mkdir "C:\Users\Public\Documents\RSView Enterprise\Help_Files_Folder"
robocopy "%~dp0\Help Files - pdf" "C:\Users\Public\Documents\RSView Enterprise\Help_Files_Folder" *.pdf /e /copy:DAT /NFL /NDL /NJH /NJS /nc /ns /np
echo    -- Copy Complete
echo.
) else (
echo    -- Destination Folder Already Exists: Help Files - pdf
robocopy "%~dp0\Help Files - pdf" "C:\Users\Public\Documents\RSView Enterprise\Help_Files_Folder" *.pdf /e /copy:DAT /NFL /NDL /NJH /NJS /nc /ns /np /IS
echo    -- Copy Complete
echo.
)

::--------------------------------------------------------------------------------------------------------------------------------------------------------

echo :: -------------------
echo :: Copying FactoryTalk View Files
echo :: -------------------
echo.

setlocal EnableDelayedExpansion

:: Ensure variables are defined
if "%_Library%"=="" (
echo Error: _Library variable is not defined.
exit /b 1
)
if "%_Version%"=="" (
echo Error: _Version variable is not defined.
exit /b 1
)

:: Define target and source paths
set "TargetDir=C:\Users\Public\Documents\RSView Enterprise\SE\Application Libraries\%_Library% %_Version%"
set "SourceDir1=%~dp0HMI - FactoryTalk View SE"
set "SourceDir2=%~dp0HMI FactoryTalk View Images - png"
set "ImageDir=%TargetDir%\Images - png"

:: Check if source directories exist
if not exist "%SourceDir1%" (
echo Error: Source directory "%SourceDir1%" does not exist.
exit /b 1
)
if not exist "%SourceDir2%" (
echo Error: Source directory "%SourceDir2%" does not exist.
exit /b 1
)

:: Create target directory if it doesn't exist
if not exist "%TargetDir%" (
echo Creating library folder "%TargetDir%"...
mkdir "%TargetDir%"
if errorlevel 1 (
echo Error: Failed to create directory "%TargetDir%".
exit /b 1
)
)

:: Create Images - png directory if it doesn't exist
if not exist "%ImageDir%" (
mkdir "%ImageDir%"
if errorlevel 1 (
echo Error: Failed to create directory "%ImageDir%".
exit /b 1
)
)

:: Copy files using robocopy with /MIR
robocopy "%SourceDir1%" "%TargetDir%" /MIR /copy:DAT /NFL /NDL /NJH /NJS /nc /ns /np >nul 2>&1
if errorlevel 8 (
    echo Error: robocopy failed to copy from "%SourceDir1%" to "%TargetDir%".
    exit /b 1
)

robocopy "%SourceDir2%" "%ImageDir%" /MIR /copy:DAT /NFL /NDL /NJH /NJS /nc /ns /np >nul 2>&1
if errorlevel 8 (
    echo Error: robocopy failed to copy from "%SourceDir2%" to "%ImageDir%".
    exit /b 1
)

echo Operation completed successfully.

:: Let user know the library is ready.
echo "Hardy Device Library %_Version% ready in FactoryTalk View SE."
echo.
:FTViewDepEnd
set _DepSts=FactoryTalk View library deployment: Complete
echo.
echo -------------------
echo %_DepSts%
echo -------------------
echo.

::--------------------------------------------------------------------------------------------------------------------------------------------------------

rem prompt for exit
Choice /C Y /t 60 /d Y /M "Exit deployment?"
if '%errorlevel%'=='1' exit

::--------------------------------------------------------------------------------------------------------------------------------------------------------